package containers

import (
	"encoding/json"

	"a.yandex-team.ru/library/go/slices"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
)

type SetOfInt map[int]struct{}

var setValue = struct{}{}

func (set SetOfInt) Add(value int) {
	set[value] = setValue
}

func NewSetOfIntFromSlice(values []int) SetOfInt {
	set := make(SetOfInt, len(values))
	for _, v := range values {
		set.Add(v)
	}
	return set
}

func NewSetOfInt(values ...int) SetOfInt {
	return NewSetOfIntFromSlice(values)
}

func (set SetOfInt) Contains(value int) bool {
	if helpers.IsNil(set) {
		return false
	}
	_, ok := set[value]
	return ok
}

func (set SetOfInt) Extend(other SetOfInt) {
	for value := range other {
		set.Add(value)
	}
}

func (set SetOfInt) ToSlice() []int {
	result := make([]int, len(set))

	var i int
	for object := range set {
		result[i] = object
		i++
	}
	return result
}

func (set SetOfInt) Intersect(other SetOfInt) SetOfInt {
	return NewSetOfIntFromSlice(slices.IntersectInts(set.ToSlice(), other.ToSlice()))
}

func (set *SetOfInt) UnmarshalJSON(b []byte) error {
	var list []int
	err := json.Unmarshal(b, &list)
	if err != nil {
		return err
	}
	s := make(map[int]struct{}, len(list))
	for _, v := range list {
		s[v] = setValue
	}
	*set = s
	return nil
}

func (set *SetOfInt) MarshalJSON() ([]byte, error) {
	if set == nil {
		return nil, nil
	}
	slice := set.ToSlice()
	return json.Marshal(slice)
}

type SetOfInterface map[interface{}]struct{}

func (set SetOfInterface) Add(value interface{}) {
	set[value] = setValue
}

func (set SetOfInterface) Extend(other SetOfInterface) {
	for value := range other {
		set.Add(value)
	}
}

func (set SetOfInterface) ToSlice() []interface{} {
	result := make([]interface{}, 0, len(set))

	for object := range set {
		result = append(result, object)
	}
	return result
}

type SetOfString map[string]struct{}

func NewSetOfString(values ...string) SetOfString {
	return NewSetOfStringFromSlices(values)
}

func (set SetOfString) Add(value string) {
	set[value] = setValue
}

func (set SetOfString) Extend(other SetOfString) {
	for value := range other {
		set.Add(value)
	}
}

func (set SetOfString) Contains(value string) bool {
	_, ok := set[value]
	return ok
}

func (set SetOfString) ToSlice() []string {
	result := make([]string, 0, len(set))

	for value := range set {
		result = append(result, value)
	}
	return result
}

func NewSetOfStringFromSlices(slices ...[]string) SetOfString {
	size := 0
	for _, s := range slices {
		size += len(s)
	}
	set := make(map[string]struct{}, size)
	for _, slice := range slices {
		for _, v := range slice {
			set[v] = setValue
		}
	}
	return set
}

func (set *SetOfString) UnmarshalJSON(b []byte) error {
	var list []string
	err := json.Unmarshal(b, &list)
	if err != nil {
		return err
	}
	s := make(map[string]struct{}, len(list))
	for _, v := range list {
		s[v] = setValue
	}
	*set = s
	return nil
}

func (set *SetOfString) MarshalJSON() ([]byte, error) {
	if set == nil {
		return nil, nil
	}
	slice := set.ToSlice()
	return json.Marshal(slice)
}

func (set *SetOfString) Remove(s string) {
	if set == nil {
		return
	}
	delete(*set, s)
}
