package logging

import (
	"log"

	arclog "a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
)

func NewApplicationLogger(loggingSettings *settings.LoggingSettings) (logger *arczap.Logger) {
	logger, err := aviaLogging.NewLogger(
		&aviaLogging.Config{
			Level:               arclog.InfoLevel,
			StdoutLoggingConfig: &aviaLogging.StdoutLoggingConfig{},
			FileLoggingConfig: &aviaLogging.FileLoggingConfig{
				FilePath:  GetLogFilePath(loggingSettings.LogPath, loggingSettings.AppLogFileName, Common),
				LogFormat: aviaLogging.Text,
			},
			SentryLoggingConfig: &aviaLogging.SentryLoggingConfig{DSN: loggingSettings.SentryDSN},
		},
	)

	if err != nil {
		log.Panicf("Couldn't create application logger. Error: %+v", err)
	}
	return logger
}
