package logging

import (
	"path"

	"a.yandex-team.ru/travel/avia/library/go/logging"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
)

type LogType string

const (
	Common LogType = "common"
	YT     LogType = "yt"
)

func GetLogFilePath(logPath, fileName string, logType LogType) string {
	switch logType {
	case Common:
		return path.Join(logPath, fileName)
	case YT:
		return path.Join(logPath, "yt", fileName)
	default:
		return path.Join(logPath, fileName)
	}
}

func GetStdoutLogFormat(settings *settings.LoggingSettings) logging.LogFormat {
	if settings.StdoutLogFormat == string(logging.JSON) {
		return logging.JSON
	}
	return logging.Text
}
