package point

import (
	"encoding/json"

	"a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/logging/yt"
)

type Logger struct {
	appLogger    log.Logger
	ytFileLogger *arczap.Logger
}

func (ytLogger *Logger) Close() {
	_ = ytLogger.ytFileLogger.L.Sync()
}

func NewLogger(logPath, fileName string, appLogger log.Logger) (logger *Logger) {
	ytFileLogger := yt.NewYtFileLogger(logPath, fileName)

	return &Logger{
		appLogger:    appLogger,
		ytFileLogger: ytFileLogger,
	}
}

func (ytLogger *Logger) Log(record *Record) {
	jsonRecord, _ := json.Marshal(record)

	logMessage := string(jsonRecord)
	ytLogger.appLogger.Info(logMessage, log.String("job_id", record.JobID))
	ytLogger.ytFileLogger.Info(logMessage)
}
