package point

import (
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/parameters"
)

type Record struct {
	MainReqID string `json:"main_req_id"`
	ReqID     string `json:"req_id"`
	JobID     string `json:"job_id"`

	FromID       *string `json:"from_id"`
	ToID         *string `json:"to_id"`
	FromPointKey *string `json:"from_point_key"`
	ToPointKey   *string `json:"to_point_key"`
	FromText     string  `json:"from_text"`
	ToText       string  `json:"to_text"`
	FromGeoID    *int    `json:"from_geo_id"`
	ToGeoID      *int    `json:"to_geo_id"`
	GeoID        int     `json:"geo_id"`

	Unixtime int64 `json:"unixtime"`
}

func NewRecord(
	queryParameters *parameters.QueryParameters,
	fromPointKey, toPointKey *string,
) *Record {
	return &Record{
		MainReqID: queryParameters.MainReqID,
		ReqID:     queryParameters.ReqID,
		JobID:     queryParameters.JobID,

		FromID:       queryParameters.FromID,
		ToID:         queryParameters.ToID,
		FromText:     queryParameters.FromText,
		ToText:       queryParameters.ToText,
		FromGeoID:    queryParameters.FromGeoID,
		ToGeoID:      queryParameters.ToGeoID,
		GeoID:        queryParameters.GeoID,
		FromPointKey: fromPointKey,
		ToPointKey:   toPointKey,

		Unixtime: time.Now().UTC().Unix(),
	}
}
