package response

import (
	"strings"
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/handlers/responses"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/parameters"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
)

type Record struct {
	MainReqID string `json:"main_reqid"`
	ReqID     string `json:"reqid"`
	JobID     string `json:"job_id"`

	Status              string                 `json:"status"`
	FlightStatus        *string                `json:"flight_status"`
	Subtype             *string                `json:"subtype"`
	Traceback           *string                `json:"traceback"`
	DefaultFlightDate   *string                `json:"default_flight_date"`
	DepartureTerminal   *string                `json:"departure_terminal"`
	ArrivalTerminal     *string                `json:"arrival_terminal"`
	DepartureGate       *string                `json:"departure_gate"`
	ArrivalGate         *string                `json:"arrival_gate"`
	DepartureAirport    *string                `json:"departure_airport"`
	ArrivalAirport      *string                `json:"arrival_airport"`
	WithFilters         bool                   `json:"with_filters"`
	DepartureDataSource *string                `json:"departure_data_source"`
	ArrivalDataSource   *string                `json:"arrival_data_source"`
	Type                *string                `json:"type"`
	Elapsed             float64                `json:"elapsed"`
	Unixtime            int64                  `json:"unixtime"`
	SearchProps         map[string]interface{} `json:"search_props"`
}

func NewRecord(
	queryParameters *parameters.QueryParameters,
	status string,
	wizardType *string,
	wizardSubtype *string,
	flightStatus *string,
	defaultFlight *responses.Flight,
	traceback *string,
	withFilters bool,
	searchProps map[string]interface{},
	elapsed float64,
) *Record {
	record := &Record{
		MainReqID:    queryParameters.MainReqID,
		ReqID:        queryParameters.ReqID,
		JobID:        queryParameters.JobID,
		Status:       status,
		FlightStatus: flightStatus,
		Subtype:      wizardSubtype,
		Traceback:    traceback,
		WithFilters:  withFilters,
		Type:         wizardType,
		SearchProps:  searchProps,
		Elapsed:      elapsed,
		Unixtime:     time.Now().UTC().Unix(),
	}
	if !helpers.IsNil(defaultFlight) {
		record.DefaultFlightDate = &strings.Split(defaultFlight.Departure.ScheduledTime, " ")[0]
		record.DepartureTerminal = defaultFlight.Departure.Terminal
		record.ArrivalTerminal = defaultFlight.Arrival.Terminal
		record.DepartureGate = defaultFlight.Departure.Gate
		record.ArrivalGate = defaultFlight.Arrival.Gate
		record.DepartureAirport = &defaultFlight.Departure.Iata
		record.ArrivalAirport = &defaultFlight.Arrival.Iata
		record.DepartureDataSource = &defaultFlight.Departure.DataSource
		record.ArrivalDataSource = &defaultFlight.Arrival.DataSource
	}
	return record
}
