package service

import "time"

type Record struct {
	JobID    string  `json:"job_id"`
	Unixtime int64   `json:"unixtime"`
	Service  string  `json:"service"`
	Method   string  `json:"method"`
	Error    bool    `json:"error"`
	Elapsed  float64 `json:"elapsed"`
}

func NewRecord(
	jobID string,
	service string,
	method string,
	callDuration time.Duration,
	isError bool,
) *Record {
	return &Record{
		JobID:    jobID,
		Service:  service,
		Method:   method,
		Elapsed:  callDuration.Seconds(),
		Error:    isError,
		Unixtime: time.Now().UTC().Unix(),
	}
}
