package show

import (
	"encoding/json"

	arczap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/logging/yt"
)

type Logger struct {
	ytFileLogger *arczap.Logger
}

func (ytLogger *Logger) Close() {
	_ = ytLogger.ytFileLogger.L.Sync()
}

func NewLogger(logPath, fileName string) (logger *Logger) {
	ytFileLogger := yt.NewYtFileLogger(logPath, fileName)

	return &Logger{
		ytFileLogger: ytFileLogger,
	}
}

func (ytLogger *Logger) Log(record *Record) {
	jsonRecord, _ := json.Marshal(record)

	logMessage := string(jsonRecord)
	ytLogger.ytFileLogger.Info(logMessage)
}
