package yt

import (
	"log"

	arclog "a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/logging"
)

func NewYtFileLogger(logPath, fileName string) (logger *arczap.Logger) {
	filePath := logging.GetLogFilePath(logPath, fileName, logging.YT)
	logger, err := aviaLogging.NewLogger(
		&aviaLogging.Config{
			Level: arclog.InfoLevel,
			FileLoggingConfig: &aviaLogging.FileLoggingConfig{
				FilePath:  filePath,
				LogFormat: aviaLogging.JSON,
			},
		},
	)
	if err != nil {
		log.Panicf("Couldn't create YtFile logger %s. Error: %s", filePath, err)
	}
	return logger
}
