package metrics

type MetricName string

var (
	general               string = "general"
	ydbPrefix             string = "ydb"
	personalizationPrefix string = "personalization"
	sharedFlightsPrefix   string = "shared_flights"
	ticketDaemonAPIPrefix string = "ticket_daemon_api"
	timingsPrefix         string = "timings"
	wizardResponseTypes   string = "response_types"
	reqidTypes            string = "reqid_types"

	wizardRequestTimings MetricName = "general"

	ticketDaemonAPIInitSearchTimings MetricName = "init_search"

	ydbStaticWithoutDateRequestTimings             MetricName = "static_without_date"
	ydbStaticByPartnerWithoutDateRequestTimings    MetricName = "static_by_partner_without_date"
	ydbExperimentalStaticWithoutDateRequestTimings MetricName = "static_without_date_experimental"
	ydbStaticWithDateRequestTimings                MetricName = "static_with_date"
	ydbStaticByPartnerWithDateRequestTimings       MetricName = "static_by_partner_with_date"
	ydbExperimentalStaticWithDateRequestTimings    MetricName = "static_with_date_experimental"
	ydbExperimentalStaticParallelRequestsTimings   MetricName = "static_experimental_parallel_requests"
	ydbDynamicRequestTimings                       MetricName = "dynamic"
	ydbDynamicByPartnerRequestTimings              MetricName = "dynamic_by_partner"
	ydbExperimentalDynamicRequestTimings           MetricName = "dynamic_experimental"
	ydbStatementPreparationTimings                 MetricName = "statement_preparation"
	ydbStatementExecutionTimings                   MetricName = "statement_execution"

	personalizationRequestTimings MetricName = "personalization_request"

	faresSortingTimings          MetricName = "fares_sorting"
	variantsBuildingTimings      MetricName = "variants_building"
	responseBuildingTimings      MetricName = "response_building"
	faresProtobufDeserialization MetricName = "fares_protobuf_deserialization"

	flightGoodRequestTimings      MetricName = "good_flights"
	flightBadRequestTimings       MetricName = "bad_flights"
	flightMultiGoodRequestTimings MetricName = "good_flights_multi"
	flightMultiBadRequestTimings  MetricName = "bad_flights_multi"
)

func (name MetricName) String() string {
	return string(name)
}
