package middlewares

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers/props"
)

type ContextPropsMiddleware struct {
	logger log.Logger
}

func (m *ContextPropsMiddleware) Handle(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		r = r.WithContext(props.WithContextProps(r.Context(), m.logger))
		next.ServeHTTP(w, r)
	})
}

func NewContextPropsMiddleware(logger log.Logger) *ContextPropsMiddleware {
	return &ContextPropsMiddleware{
		logger: logger,
	}
}
