package middlewares

import (
	"encoding/json"
	"fmt"
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	wizardContext "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/context"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/handlers/responses"
)

type RecoverMiddleware struct {
	appLogger log.Logger
}

func (m *RecoverMiddleware) Handle(next http.Handler) http.Handler {
	return http.HandlerFunc(func(writer http.ResponseWriter, request *http.Request) {
		defer func() {
			if r := recover(); r != nil {
				errorMessage := fmt.Sprintf("An error is caught: %+v", r)
				m.appLogger.Error(errorMessage, log.String("job_id", wizardContext.GetJobID(request.Context())))
				writer.WriteHeader(http.StatusInternalServerError)
				_ = json.NewEncoder(writer).Encode(responses.NewErrorResponseFromString(errorMessage, nil, nil))
			}
		}()
		next.ServeHTTP(writer, request)
	})
}

func NewRecoverMiddleware(appLogger log.Logger) *RecoverMiddleware {
	return &RecoverMiddleware{appLogger}
}
