package middlewares

import (
	"net/http"

	"a.yandex-team.ru/travel/avia/library/go/utils"
	wizardContext "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/context"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/handlers/responses"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
)

type ReqIDFilterMiddleware struct {
	jobIDGenerator helpers.JobIDGenerator
}

func (m *ReqIDFilterMiddleware) Handle(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		queryParameters := utils.HTTP.ParseQueryParameters(r)
		mainReqIDValue := queryParameters.Get("main_reqid")
		if mainReqIDValue == "" {
			utils.HTTP.JSON(
				w, http.StatusBadRequest,
				responses.NewErrorResponse("main_reqid query parameter is required", "bad_arguments"),
			)
			return
		}
		reqIDValue := queryParameters.Get("reqid")
		if reqIDValue == "" {
			utils.HTTP.JSON(
				w, http.StatusBadRequest,
				responses.NewErrorResponse("reqid query parameter is required", "bad_arguments"),
			)
			return
		}
		r = r.WithContext(wizardContext.WithJobID(r.Context(), m.jobIDGenerator.Generate()))
		next.ServeHTTP(w, r)
	})
}

func NewReqIDFilterMiddleware(jobIDGenerator helpers.JobIDGenerator) *ReqIDFilterMiddleware {
	return &ReqIDFilterMiddleware{jobIDGenerator: jobIDGenerator}
}
