package middlewares

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers/props"
)

type SearchPropsMiddleware struct {
	logger log.Logger
}

func (m *SearchPropsMiddleware) Handle(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		r = r.WithContext(props.WithSearchPropsStore(r.Context(), m.logger))
		next.ServeHTTP(w, r)
	})
}

func NewSearchPropsMiddleware(logger log.Logger) *SearchPropsMiddleware {
	return &SearchPropsMiddleware{
		logger: logger,
	}
}
