package middlewares

import (
	"net/http"

	"github.com/opentracing/opentracing-go"

	"a.yandex-team.ru/travel/avia/library/go/utils"
)

type TracingMiddleware struct {
	tracer opentracing.Tracer
}

func (m *TracingMiddleware) Handle(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		reqID := utils.HTTP.ParseQueryParameters(r).Get("reqid")
		rootSpan := opentracing.GlobalTracer().StartSpan("wizard request", opentracing.Tag{Key: "reqid", Value: reqID})
		defer rootSpan.Finish()
		r = r.WithContext(opentracing.ContextWithSpan(r.Context(), rootSpan))
		next.ServeHTTP(w, r)
	})
}

func NewTracingMiddleware(tracer opentracing.Tracer) *TracingMiddleware {
	return &TracingMiddleware{tracer: tracer}
}
