package repositories

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	AviaCompany interface {
		GetAll() []*models.AviaCompany
		GetByID(id int) (*models.AviaCompany, bool)
	}

	idToAviaCompanyMapper map[int]*models.AviaCompany

	AviaComopanyRepository struct {
		aviaCompanyReference  *references.AviaCompany
		idToAviaCompanyMapper idToAviaCompanyMapper
	}
)

func NewAviaCompanyRepository(
	aviaCompanyReference *references.AviaCompany,
) AviaCompany {
	repository := &AviaComopanyRepository{
		aviaCompanyReference:  aviaCompanyReference,
		idToAviaCompanyMapper: make(idToAviaCompanyMapper),
	}

	for _, company := range aviaCompanyReference.GetAll() {
		repository.idToAviaCompanyMapper[company.RaspCompanyID] = company
	}

	return repository
}

func (repository *AviaComopanyRepository) GetAll() []*models.AviaCompany {
	return repository.aviaCompanyReference.GetAll()
}

func (repository *AviaComopanyRepository) GetByID(id int) (*models.AviaCompany, bool) {
	aviaCompany, found := repository.idToAviaCompanyMapper[id]
	return aviaCompany, found
}
