package repositories

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/containers"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
)

type (
	BannedFlight interface {
		IsBanned(flightNumber string) bool
	}

	BannedFlightRepository struct {
		bannedFlights containers.SetOfString
	}
)

func NewBannedFlightRepository(settings *settings.Settings, logger log.Logger) *BannedFlightRepository {
	logger.Info(fmt.Sprintf("Banned flights: %s", settings.BannedFlights))

	flightNumbers := strings.Split(settings.BannedFlights, ";")
	repository := &BannedFlightRepository{
		bannedFlights: make(containers.SetOfString, len(flightNumbers)),
	}

	for _, flightNumber := range flightNumbers {
		repository.bannedFlights.Add(normalizeNumber(flightNumber))
	}
	return repository
}

func (repository *BannedFlightRepository) IsBanned(flightNumber string) bool {
	_, found := repository.bannedFlights[normalizeNumber(flightNumber)]
	return found
}

func normalizeNumber(number string) string {
	number = strings.ReplaceAll(number, " ", "")
	number = strings.ReplaceAll(number, "-", "")
	return strings.ToLower(number)
}
