package repositories

import (
	"sync"
	"time"
)

type CachedLocation interface {
	LoadLocation(location string) (*time.Location, error)
}

type CachedLocationRepository struct {
	cache sync.Map
}

func NewCachedLocationRepository() CachedLocation {
	return &CachedLocationRepository{}
}

func (repository *CachedLocationRepository) LoadLocation(location string) (*time.Location, error) {
	if loc, ok := repository.cache.Load(location); ok {
		return loc.(*time.Location), nil
	}
	loc, err := time.LoadLocation(location)
	if err == nil {
		repository.cache.Store(location, loc)
	}
	return loc, err
}
