package repositories

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	CompanyTariff interface {
		GetAll() []*models.CompanyTariff
		GetTariffsByCompanyID(id int) ([]*models.CompanyTariff, bool)
	}

	companyIDToTariffsMapper map[int][]*models.CompanyTariff

	CompanyTariffRepository struct {
		companyTariffReference   *references.CompanyTariff
		companyIDToTariffsMapper companyIDToTariffsMapper
	}
)

func NewCompanyTariffRepository(companyTariff *references.CompanyTariff) CompanyTariff {
	repository := &CompanyTariffRepository{
		companyTariffReference:   companyTariff,
		companyIDToTariffsMapper: make(companyIDToTariffsMapper),
	}

	for _, tariff := range companyTariff.GetAll() {
		if tariff.Published {
			repository.companyIDToTariffsMapper[tariff.AviaCompanyID] = append(
				repository.companyIDToTariffsMapper[tariff.AviaCompanyID], tariff)
		}
	}
	return repository
}

func (repository *CompanyTariffRepository) GetAll() []*models.CompanyTariff {
	return repository.companyTariffReference.GetAll()
}

func (repository *CompanyTariffRepository) GetTariffsByCompanyID(id int) ([]*models.CompanyTariff, bool) {
	companyTariffs, found := repository.companyIDToTariffsMapper[id]
	return companyTariffs, found
}
