package repositories

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	Country interface {
		GetAll() []*models.Country
		GetByID(int) (*models.Country, bool)
		GetByGeoID(int) (*models.Country, bool)
	}

	idToCountry map[int]*models.Country

	CountryRepository struct {
		countryReference *references.Country

		idToCountry    idToCountry
		geoIDToCountry idToCountry
	}
)

func NewCountryRepository(countryReference *references.Country) Country {
	repository := &CountryRepository{countryReference: countryReference, idToCountry: make(idToCountry), geoIDToCountry: make(idToCountry)}
	for _, country := range countryReference.GetAll() {
		repository.idToCountry[country.ID] = country
		repository.geoIDToCountry[country.GeoID] = country
	}
	return repository
}

func (repository *CountryRepository) GetAll() []*models.Country {
	return repository.countryReference.GetAll()
}

func (repository *CountryRepository) GetByID(id int) (*models.Country, bool) {
	s, ok := repository.idToCountry[id]
	return s, ok
}

func (repository *CountryRepository) GetByGeoID(id int) (*models.Country, bool) {
	s, ok := repository.geoIDToCountry[id]
	return s, ok
}
