package repositories

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	Currency interface {
		GetByCode(code string) *models.Currency
	}

	codeToCurrencyMapper map[string]*models.Currency

	CurrencyRepository struct {
		currencyReference    *references.Currency
		codeToCurrencyMapper codeToCurrencyMapper
	}
)

func NewCurrencyRepository(currencyReference *references.Currency) Currency {
	repository := &CurrencyRepository{
		currencyReference:    currencyReference,
		codeToCurrencyMapper: make(codeToCurrencyMapper),
	}

	for _, currency := range currencyReference.GetAll() {
		if currency.Code != "" {
			repository.codeToCurrencyMapper[currency.Code] = currency
		}
	}
	return repository
}

func (repository *CurrencyRepository) GetByCode(code string) *models.Currency {
	return repository.codeToCurrencyMapper[code]
}
