package repositories

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	Region interface {
		GetAll() []*models.Region
		GetByID(int) (*models.Region, bool)
		GetByGeoID(int) (*models.Region, bool)
	}

	idToRegion map[int]*models.Region

	RegionRepository struct {
		regionReference *references.Region

		idToRegion    idToRegion
		geoIDToRegion idToRegion
	}
)

func NewRegionRepository(regionReference *references.Region) Region {
	repository := &RegionRepository{regionReference: regionReference, idToRegion: make(idToRegion), geoIDToRegion: make(idToRegion)}
	for _, region := range regionReference.GetAll() {
		repository.idToRegion[region.ID] = region
		repository.geoIDToRegion[region.GeoID] = region
	}
	return repository
}

func (repository *RegionRepository) GetAll() []*models.Region {
	return repository.regionReference.GetAll()
}

func (repository *RegionRepository) GetByID(id int) (*models.Region, bool) {
	s, ok := repository.idToRegion[id]
	return s, ok
}

func (repository *RegionRepository) GetByGeoID(id int) (*models.Region, bool) {
	s, ok := repository.geoIDToRegion[id]
	return s, ok
}
