package repositories

import (
	"time"
)

type (
	SettlementTimeZone interface {
		GetByID(id int) *time.Location
		GetByGeoID(geoID int) *time.Location
	}
	SettlementTimeZoneRepository struct {
		settlementRepository Settlement
	}
)

func NewSettlementTimeZoneRepository(
	settlementRepository Settlement,
) *SettlementTimeZoneRepository {
	return &SettlementTimeZoneRepository{
		settlementRepository: settlementRepository,
	}
}

func (repository *SettlementTimeZoneRepository) GetByID(id int) *time.Location {
	if settlement, found := repository.settlementRepository.GetByID(id); found {
		if location, err := time.LoadLocation(settlement.TimeZone); err == nil {
			return location
		}
	}
	return nil
}

func (repository *SettlementTimeZoneRepository) GetByGeoID(geoID int) *time.Location {
	if settlement, found := repository.settlementRepository.GetByGeoID(geoID); found {
		if location, err := time.LoadLocation(settlement.TimeZone); err == nil {
			return location
		}
	}
	return nil
}
