package repositories

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	StationToSettlement interface {
		GetSettlementsByStationID(stationID int) []*models.Settlement
	}
	settlements            []*models.Settlement
	stationIDToSettlements map[int]settlements

	StationToSettlementRepository struct {
		stationIDToSettlements stationIDToSettlements
	}
)

func NewStationToSettlementRepository(
	settlementRepository Settlement,
	settlementToSettlementReference *references.StationToSettlement,
) *StationToSettlementRepository {
	repository := &StationToSettlementRepository{
		stationIDToSettlements: make(stationIDToSettlements),
	}
	for _, relation := range settlementToSettlementReference.GetAll() {
		if settlement, found := settlementRepository.GetByID(relation.SettlementID); found {
			repository.stationIDToSettlements[relation.StationID] = append(
				repository.stationIDToSettlements[relation.StationID], settlement)
		}
	}
	return repository
}

func (repository *StationToSettlementRepository) GetSettlementsByStationID(stationID int) []*models.Settlement {
	if result, found := repository.stationIDToSettlements[stationID]; found {
		return result
	}
	return make(settlements, 0)
}
