package ydb

import (
	"context"
	"time"

	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb/table"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
)

func GetSessionPool(ctx context.Context, settings *settings.YdbSettings) (*table.SessionPool, error) {
	driver, err := ydb.Dial(ctx, settings.Cluster, &ydb.DriverConfig{
		Database: settings.DB,
		Credentials: ydb.AuthTokenCredentials{
			AuthToken: settings.Token,
		},
	})
	if err != nil {
		return nil, err
	}
	tableClient := table.Client{
		Driver: driver,
	}

	return &table.SessionPool{
		SizeLimit:          -1,           // No limits for pool size.
		KeepAliveBatchSize: -1,           // Keep alive as much as possible number of sessions.
		IdleThreshold:      time.Second,  // Keep alive idle session every second.
		Builder:            &tableClient, // Create new sessions within tableClient.
	}, nil
}
