package featureflag

import "a.yandex-team.ru/travel/avia/library/go/services/featureflag"

const (
	boyEnable     = "BOY_AFL_ENABLE"      // включает бой
	boyServiceAll = "BOY_AFL_SERVICE_ALL" // этот флаг ограничивает бой переходами с сервиса. Иначе говоря отключает колдун
)

type Storage struct {
	storage *featureflag.Storage
}

func NewStorage(storage *featureflag.Storage) *Storage {
	return &Storage{storage: storage}
}

func (s Storage) BoyIsEnabled(abFlags featureflag.ABFlags) bool {
	return s.isFlagEnabledABOverride(boyEnable, abFlags) &&
		!s.isFlagEnabledABOverride(boyServiceAll, abFlags)
}

func (s Storage) isFlagEnabledABOverride(flagCode string, abFlags featureflag.ABFlags) bool {
	return s.storage.GetFlags().IsFlagEnabledABOverride(flagCode, abFlags)
}
