package personalization

import (
	"time"

	personalsearch "a.yandex-team.ru/travel/avia/personalization/api/personal_search/v2"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	PersonalSearchMapper struct {
	}
)

func NewPersonalSearchMapper() *PersonalSearchMapper {
	return &PersonalSearchMapper{}
}

type PersonalSearchSuggest struct {
	DepartureDate time.Time
}

func (mapper *PersonalSearchMapper) Map(
	fromSettlement, toSettlement *models.Settlement,
	personalizationResponse *personalsearch.TGetPersonalSearchResponseV2,
) PersonalSearchSuggest {
	result := PersonalSearchSuggest{}
	if personalizationResponse == nil {
		return result
	}
	for _, entry := range personalizationResponse.Entries {
		if entry.GetAvia().GetPointFrom().PointCode == fromSettlement.GetPointKey() && entry.GetAvia().GetPointTo().PointCode == toSettlement.GetPointKey() {
			personalizedDepartureDate, _ := time.Parse("2006-01-02", entry.GetAvia().GetWhen())
			result.DepartureDate = personalizedDepartureDate
			return result
		}
	}
	return result
}
