package tdapi

import (
	"context"
	"net/url"
	"strconv"
	"strings"
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/parameters"
)

type InitSearchRequest struct {
	PointKeyFrom    string
	PointKeyTo      string
	DateForward     time.Time
	QueryParameters *parameters.QueryParameters
	Context         context.Context
	CacheTypes      []string
}

func (request *InitSearchRequest) ToURLValues() url.Values {
	passengers := request.QueryParameters.Passengers()
	values := url.Values{}
	values.Set("point_from", request.PointKeyFrom)
	values.Set("point_to", request.PointKeyTo)
	values.Set("date_forward", request.DateForward.Format("2006-01-02"))
	if request.QueryParameters.ReturnDate != nil {
		values.Set("date_backward", request.QueryParameters.ReturnDate.Format("2006-01-02"))
	}
	values.Set("national", request.QueryParameters.NationalVersion)
	values.Set("lang", request.QueryParameters.Lang.String())
	values.Set("adults", strconv.Itoa(passengers.Adults))
	values.Set("children", strconv.Itoa(passengers.Children))
	values.Set("infants", strconv.Itoa(passengers.Infants))
	values.Set("main_reqid", request.QueryParameters.MainReqID)
	values.Set("reqid", request.QueryParameters.ReqID)
	values.Set("job_id", request.QueryParameters.JobID)
	if len(request.CacheTypes) > 0 {
		values.Set("wizard_caches", strings.Join(request.CacheTypes, ","))
	}

	return values
}
