package settings

import "a.yandex-team.ru/library/go/core/log"

type LoggingSettings struct {
	LogLevel                string `config:"AVIA_WIZARD_LOG_LEVEL" yaml:"level"`
	LogPath                 string `config:"AVIA_WIZARD_LOG_PATH" yaml:"path"`
	SentryDSN               string `config:"AVIA_WIZARD_SENTRY_DSN" yaml:"sentry_dsn"`
	SentryLogLevel          string `config:"AVIA_WIZARD_SENTRY_LOG_LEVEL" yaml:"sentry_log_level"`
	StdoutLogFormat         string `config:"QLOUD_LOGGER_STDOUT_PARSER" yaml:"stdout_log_format"`
	AppLogFileName          string `yaml:"app_log_file_name"`
	ResponseJSONLogFileName string `yaml:"response_json_log_file_name"`
	Yt                      YtLoggingSettings
}

type YtLoggingSettings struct {
	QueryLogFileName       string `yaml:"query_log_file_name"`
	ResponseLogFileName    string `yaml:"response_log_file_name"`
	PointParseLogFileName  string `yaml:"point_parse_log_file_name"`
	ShowLogFileName        string `yaml:"show_log_file_name"`
	ServiceCallLogFileName string `yaml:"service_call_log_file_name"`

	HeatingQueryLogFileName       string `yaml:"heating_query_log_file_name"`
	HeatingResponseLogFileName    string `yaml:"heating_response_log_file_name"`
	HeatingPointParseLogFileName  string `yaml:"heating_point_parse_log_file_name"`
	HeatingShowLogFileName        string `yaml:"heating_show_log_file_name"`
	HeatingServiceCallLogFileName string `yaml:"heating_service_call_log_file_name"`
}

func defaultLoggingSettings() *LoggingSettings {
	return &LoggingSettings{
		LogLevel:                log.InfoString,
		SentryLogLevel:          log.ErrorString,
		AppLogFileName:          "app.log",
		ResponseJSONLogFileName: "response_json.log",
		Yt: YtLoggingSettings{
			QueryLogFileName:       "query.log",
			ResponseLogFileName:    "response.log",
			PointParseLogFileName:  "point_parse.log",
			ShowLogFileName:        "show.log",
			ServiceCallLogFileName: "service_calls.log",

			HeatingQueryLogFileName:       "heating-query.log",
			HeatingResponseLogFileName:    "heating-response.log",
			HeatingPointParseLogFileName:  "heating-point_parse.log",
			HeatingShowLogFileName:        "heating-show.log",
			HeatingServiceCallLogFileName: "heating-service_calls.log",
		},
	}
}
