package settings

import "time"

type MetricsSettings struct {
	Perf *PerfMetricsSettings
}

type PerfMetricsSettings struct {
	Prefix          string
	RefreshInterval time.Duration `yaml:"refresh_interval"`
}

func defaultMetricsSettings() *MetricsSettings {
	return &MetricsSettings{
		Perf: &PerfMetricsSettings{
			Prefix:          "perf",
			RefreshInterval: 5 * time.Second,
		},
	}
}
