package settings

import (
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
)

type ReferencesSettings struct {
	BackendBaseURL          string        `config:"AVIA_WIZARD_BACKEND_BASE_URL" yaml:"backend_base_url"`
	RecachePartnersInterval time.Duration `config:"AVIA_WIZARD_RECACHE_PARTNERS_INTERVAL,description=The interval at which partners will be taken from avia-backend (in seconds)" yaml:"recache_partners_interval"`
	Resources               references.Config
}

func defaultReferencesSettings() *ReferencesSettings {
	return &ReferencesSettings{
		BackendBaseURL:          "http://backend.testing.avia.yandex.net/",
		RecachePartnersInterval: 3 * time.Minute,
		Resources:               references.DefaultConfig,
	}
}
