package settings

import "time"

type SearchSettings struct {
	FetchVariantsFromPartnerTable bool          `config:"AVIA_WIZARD_FETCH_VARIANTS_FROM_PARTNER_TABLE" yaml:"fetch_variants_from_partner_table"`
	NearDateTTL                   time.Duration `config:"AVIA_WIZARD_NEAR_DATE_TTL" yaml:"near_date_ttl"`
	FarDateTTL                    time.Duration `config:"AVIA_WIZARD_FAR_DATE_TTL" yaml:"far_date_ttl"`
	DefaultTTL                    time.Duration `config:"AVIA_WIZARD_DEFAULT_TTL" yaml:"default_ttl"`
	NearDaysCount                 int           `config:"AVIA_WIZARD_NEAR_DAYS_COUNT" yaml:"near_days_count"`
}

func defaultSearchSettings() *SearchSettings {
	return &SearchSettings{
		NearDateTTL:   360 * time.Minute,
		FarDateTTL:    72 * 60 * time.Minute,
		DefaultTTL:    15 * time.Hour,
		NearDaysCount: 1,
	}
}
