package settings

import (
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/consts"
)

type YdbSettings struct {
	Token             string `config:"YDB_TOKEN,required"`
	Cluster           string `config:"AVIA_WIZARD_YDB_CLUSTER,required"`
	DB                string `config:"AVIA_WIZARD_YDB_DATABASE,required"`
	Table             string `config:"AVIA_WIZARD_YDB_TABLE,required"`
	PartnerTable      string `config:"AVIA_WIZARD_YDB_PARTNER_TABLE,required" yaml:"partner_table"`
	ExperimentalTable string `config:"AVIA_WIZARD_YDB_EXPERIMENTAL_TABLE,required" yaml:"experimental_table"`

	PreparedSessionsCount          int           `config:"AVIA_WIZARD_YDB_PREPARED_SESSIONS_COUNT,required" yaml:"prepared_sessions_count"`
	StaticRequestTimeout           time.Duration `config:"AVIA_WIZARD_YDB_STATIC_REQUEST_TIMEOUT,required" yaml:"static_request_timeout"`
	DynamicRequestTimeout          time.Duration `config:"AVIA_WIZARD_YDB_DYNAMIC_REQUEST_TIMEOUT,required" yaml:"dynamic_request_timeout"`
	DynamicRequestByPartnerTimeout time.Duration `config:"AVIA_WIZARD_YDB_DYNAMIC_REQUEST_BY_PARTNER_TIMEOUT,required" yaml:"dynamic_request_by_partner_timeout"`
}

func defaultYdbSettings() *YdbSettings {
	return &YdbSettings{
		Table:                          consts.WizardResults,
		PartnerTable:                   consts.WizardResultsByPartner,
		ExperimentalTable:              consts.WizardResultsExperimental,
		PreparedSessionsCount:          10,
		StaticRequestTimeout:           50 * time.Millisecond,
		DynamicRequestTimeout:          150 * time.Millisecond,
		DynamicRequestByPartnerTimeout: 300 * time.Millisecond,
	}
}
