package settings

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/consts"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/containers"
)

var (
	AllowedTld              = containers.NewSetOfString("ru", "ua", "by", "kz", "com.tr")
	AllowedNationalVersions = containers.NewSetOfString("ru", "ua", "tr", "kz", "by")
	AllowedLanguages        = containers.NewSetOfString(
		consts.LangRU.String(),
		consts.LangTR.String(),
		consts.LangUK.String(),
		consts.LangKK.String(),
		consts.LangBE.String(),
		consts.LangEN.String(),
	)
)

func IsAllowedLanguage(lang models.Lang) bool {
	return AllowedLanguages.Contains(lang.String())
}

func IsAllowedTld(tld string) bool {
	return AllowedTld.Contains(tld)
}

func IsAllowedNationalVersion(nationalVersion string) bool {
	return AllowedNationalVersions.Contains(nationalVersion)
}
