package tracing

import (
	"fmt"
	"io"

	"github.com/opentracing/opentracing-go"
	"github.com/uber/jaeger-client-go"
	"github.com/uber/jaeger-client-go/config"

	"a.yandex-team.ru/library/go/core/log"
)

func ConfigureTracer(appLogger log.Logger) io.Closer {
	tracer, closer, err := config.Configuration{
		ServiceName: "avia.wizard",
		Sampler: &config.SamplerConfig{
			Type:  jaeger.SamplerTypeConst,
			Param: 1,
		},
	}.NewTracer()
	if err != nil {
		appLogger.Fatal(fmt.Sprintf("couldn't create Jaeger tracer. error: %+v", err))
		panic(err)
	}
	opentracing.SetGlobalTracer(tracer)
	return closer
}
