package translations

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/tanker"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/consts"
)

type CommonTranslator struct {
	tanker                 tanker.ITranslator
	logger                 log.Logger
	pointDeclinatorFactory *PointDeclinatorFactory
}

func NewCommonTranslator(
	tanker tanker.ITranslator,
	logger log.Logger,
	pointDeclinatorFactory *PointDeclinatorFactory) *CommonTranslator {
	return &CommonTranslator{
		tanker:                 tanker,
		logger:                 logger,
		pointDeclinatorFactory: pointDeclinatorFactory,
	}
}

func (translator *CommonTranslator) LocServiceName(lang models.Lang, usePortal consts.TravelPortalUsage) string {
	if usePortal {
		return suppress(translator.tanker.GetTranslation("greenurl_1_avia-tavel", lang))
	}
	return suppress(translator.tanker.GetTranslation("Яндекс.Авиабилеты", lang))
}

func (translator *CommonTranslator) LocButton(lang models.Lang) string {
	return suppress(translator.tanker.GetTranslation("Найти авиабилеты", lang))
}

func (translator *CommonTranslator) LocCommonWizardText(lang models.Lang) string {
	return suppress(translator.tanker.GetTranslation("content_text_common_wizard", lang))
}

func (translator *CommonTranslator) LocAirlineRoutes(company string, lang models.Lang) string {
	return suppress(translator.tanker.GetTemplatedTranslation(
		"Билеты на рейсы авиакомпании «{{.company}}»",
		lang,
		GetPlaceholder(Pair{"company", company}),
	))
}

func (translator *CommonTranslator) LocCommonAirlineTitle(
	companyTitle string,
	settlement models.Point,
	lang models.Lang,
) (string, error) {
	return translator.tanker.GetTemplatedTranslationWithCase(
		"{{.company}}: дешёвые авиабилеты из {{case .city_from \"genitive\"}}",
		lang,
		GetPlaceholder(
			Pair{"company", companyTitle},
			Pair{"city_from", settlement},
		),
		translator.pointDeclinatorFactory.Get(lang),
	)
}

func getTitleKey(usePortal consts.TravelPortalUsage, withServiceName bool) string {
	if withServiceName {
		if usePortal {
			return "Дешёвые авиабилеты из {{case .city_from \"genitive\"}} на Яндекс.Путешествиях"
		}
		return "Дешёвые авиабилеты из {{case .city_from \"genitive\"}} на Яндекс.Авиабилетах"
	}
	return "cheap_tickets_from"
}

func (translator *CommonTranslator) LocCommonTitle(
	settlement models.Point,
	lang models.Lang,
	usePortal consts.TravelPortalUsage,
	withServiceName bool,
) (string, error) {
	key := getTitleKey(usePortal, withServiceName)
	return translator.tanker.GetTemplatedTranslationWithCase(
		key,
		lang,
		GetPlaceholder(
			Pair{"city_from", settlement},
		),
		translator.pointDeclinatorFactory.Get(lang),
	)
}

func (translator *CommonTranslator) LocCommonTicketsFrom(settlement *models.Settlement, lang models.Lang) (string, error) {
	return translator.tanker.GetTemplatedTranslationWithCase(
		"Билеты на рейсы из {{case .city_from \"genitive\"}}",
		lang,
		GetPlaceholder(Pair{"city_from", settlement}),
		translator.pointDeclinatorFactory.Get(lang),
	)
}

func suppress(value string, _ error) string {
	return value
}
