package translations

type Pair struct {
	key   string
	value interface{}
}

func GetPlaceholder(pairs ...Pair) map[string]interface{} {
	result := make(map[string]interface{}, len(pairs))
	for _, pair := range pairs {
		result[pair.key] = pair.value
	}
	return result
}

type titlePlaceholder struct {
	flightNumber,
	fromTitle,
	toTitle,
	airline string
}

func (data *titlePlaceholder) getTitlePlaceholder() map[string]interface{} {
	return map[string]interface{}{
		"flight_number": data.flightNumber,
		"from_title":    data.fromTitle,
		"to_title":      data.toTitle,
		"airline":       data.airline,
	}
}

func (data *titlePlaceholder) getContentTextPlaceholder() map[string]interface{} {
	return map[string]interface{}{
		"flightNumber": data.flightNumber,
		"fromTitle":    data.fromTitle,
		"toTitle":      data.toTitle,
		"company":      data.airline,
	}
}
