package translations

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/tanker"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/consts"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/repositories"
)

type PointDeclinatorFactory struct {
	translatedTitleRepository repositories.TranslatedTitle
	registry                  map[models.Lang]tanker.PointDeclinator
}

func NewPointDeclinatorFactory(translatedTitleRepository repositories.TranslatedTitle) *PointDeclinatorFactory {
	return &PointDeclinatorFactory{
		translatedTitleRepository: translatedTitleRepository,
		registry:                  make(map[models.Lang]tanker.PointDeclinator),
	}
}

func (factory *PointDeclinatorFactory) Get(lang models.Lang) tanker.PointDeclinator {
	if declinator, ok := factory.registry[lang]; ok {
		return declinator
	}
	declinator := func(point models.Point, grammaticalCase ...models.GrammaticalCase) (string, error) {
		if len(grammaticalCase) == 0 {
			grammaticalCase = append(grammaticalCase, consts.CaseNominative)
		}
		return factory.translatedTitleRepository.GetTitleTranslation(point.GetTitleID(), lang, grammaticalCase[0])
	}
	factory.registry[lang] = declinator
	return declinator
}
