package translations

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/tanker"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
)

func GetTranslator(appSettings *settings.Settings, logger log.Logger) *tanker.Translator {
	keyset, err := tanker.ReadWizardKeyset(appSettings.TankerKeysetPath, logger)
	helpers.PanicIfNotNil(err)
	return tanker.NewTranslator(appSettings.Languages, keyset, logger)
}
