package translations

import (
	"unicode"
)

// Given an unicode encoded string, returns
// another string with non-ASCII characters replaced
// with their closest ASCII counterparts.
// e.g. Unicode("áéíóú") => "aeiou"
func Unidecode(s string) string {
	str := ""
	for _, c := range s {
		if c <= unicode.MaxASCII {
			str += string(c)
			continue
		}
		if c > unicode.MaxRune {
			/* Ignore reserved chars */
			continue
		}
		if d, ok := transliterations[c]; ok {
			str += d
		}
	}
	return str
}
