#!/usr/bin/env bash
set -ex

cd $(dirname "${BASH_SOURCE[0]}")/..

ya make --yt-store ../tools/sandbox_token

SANDBOX_TOKEN=$(../tools/sandbox_token/get_sandbox_token)

mkdir -p dev/common_dicts

wget -O dev/common_dicts/TRAVEL_AVIA_COMMON_DICTS_BUNDLE --header="Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/TRAVEL_AVIA_COMMON_DICTS_BUNDLE
tar -C dev/common_dicts -xvf dev/common_dicts/TRAVEL_AVIA_COMMON_DICTS_BUNDLE

mkdir -p dev/conversions
wget -O dev/conversions/partner_conversions.data --header="Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/AVIA_PARTNER_CONVERSIONS
