# -*- coding: utf-8 -*-
from flask import Flask

from travel.avia.yeah.database import db
from travel.avia.yeah.views import heater_config


def create_app():
    app = Flask('yeah')
    app.config.from_object('travel.avia.yeah.settings')
    app.register_blueprint(heater_config.heater_config_bp)
    app.route('/ping')(lambda: 'ok')
    db.init_app(app)
    return app


def make_celery(app):
    import celery

    class Celery(celery.Celery):
        pass

    celery_app = Celery(
        app.import_name,
        backend=app.config['CELERY_RESULT_BACKEND'],
        broker=app.config['CELERY_BROKER_URL']
    )
    celery_app.conf.update(app.config)

    class ContextTask(celery.Task):
        def __call__(self, *args, **kwargs):
            with app.app_context():
                return self.run(*args, **kwargs)

    celery_app.Task = ContextTask
    return celery_app
