import logging

from celery.app import Celery
from celery.signals import after_setup_logger

from travel.avia.yeah import settings

celery_app = Celery('yeah')
celery_app.config_from_object(settings)


@after_setup_logger.connect
def setup_loggers(logger, *args, **kwargs):
    formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')

    # FileHandler
    fh = logging.FileHandler(settings.LOG_PATH)
    fh.setFormatter(formatter)
    logger.addHandler(fh)
