"""create heater config table

Revision ID: 0e132a3e453c
Revises:
Create Date: 2019-02-15 12:42:15.738692+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0e132a3e453c'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('heater_config',
    sa.Column('pk', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('code_from', sa.String(), nullable=False),
    sa.Column('code_to', sa.String(), nullable=False),
    sa.Column('experiment', sa.String(), nullable=False),
    sa.Column('req_count', sa.Integer(), nullable=False),
    sa.Column('travel_time', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.Column('adults_count', sa.SmallInteger(), nullable=False),
    sa.Column('children_count', sa.SmallInteger(), nullable=False),
    sa.Column('infants_count', sa.SmallInteger(), nullable=False),
    sa.Column('forward_date', sa.Date(), nullable=False),
    sa.Column('backward_date', sa.Date(), nullable=False),
    sa.Column('national_version', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('national_version', 'adults_count', 'children_count', 'infants_count', 'code_from', 'code_to', 'forward_date', 'backward_date', name='heater_config_unique')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('heater_config')
    # ### end Alembic commands ###
