class ResultsMeta:
    def __init__(self, data: dict):
        self.__data = data

    @property
    def partners(self):
        return [p_code for p_code, meta in self.__data.items() if meta is not None]

    @property
    def max_created(self):
        if self.partners:
            return max([
                meta['created'] for meta in self.__data.values()
                if meta is not None
            ])
        return None
