import os


basedir = os.path.abspath(os.path.dirname(__file__))


class LocalSettings:
    def __init__(self, settings_path):
        self._local_settings = {}
        try:
            with open(settings_path) as f:
                for line in f:
                    local_vars = line.split('=', 1)
                    if len(local_vars) > 1:
                        self._local_settings[local_vars[0].strip()] = local_vars[1].strip()
        except IOError:
            pass

    def get_env(self, key, default=None):
        return self._local_settings.get(key, os.getenv(key, default))


_local_settings = LocalSettings(
    settings_path=os.path.join(basedir, '..', 'dev', 'local_settings.env')
)

YANDEX_ENVIRONMENT_TYPE = _local_settings.get_env('YANDEX_ENVIRONMENT_TYPE')

DEBUG = YANDEX_ENVIRONMENT_TYPE == 'development'

SQS_ENDPOINT = 'sqs.yandex.net:8771'
SQS_ACCESS_KEY = _local_settings.get_env('YEAH_SQS_ACCESS_KEY')
SQS_SECRET_KEY = _local_settings.get_env('YEAH_SQS_SECRET_KEY')
BROKER_URL = 'sqs://%s:%s@%s' % (SQS_ACCESS_KEY, SQS_SECRET_KEY, SQS_ENDPOINT)
BROKER_TRANSPORT_OPTIONS = {
    'is_secure': False,
    'region': 'yandex',
}

WARMING_UP_RATE_LIMIT = '120/m'

CELERY_IMPORTS = ('travel.avia.yeah.tasks.heater',)

queue_yeah_warming_up = '{}_yeah_warming_up'.format(YANDEX_ENVIRONMENT_TYPE)
CELERY_ROUTES = {
    'travel.avia.yeah.tasks.heater.warming_up': {
        'queue': queue_yeah_warming_up,
    },
}
CELERY_QUEUES = {
    queue_yeah_warming_up: {},
}

SENTRY_DSN = None

DB_NAME = 'yeah'
DB_LOGIN = _local_settings.get_env('YEAH_DB_LOGIN')
DB_PASSWORD = _local_settings.get_env('YEAH_DB_PASSWORD')
DB_HOST = _local_settings.get_env('YEAH_DB_HOST')
DB_PORT = _local_settings.get_env('YEAH_DB_PORT')

SQLALCHEMY_DATABASE_URI = 'postgresql+psycopg2://{}:{}@{}:{}/{}'.format(
    DB_LOGIN, DB_PASSWORD, DB_HOST, DB_PORT, DB_NAME,
)
SQLALCHEMY_MIGRATE_REPO = os.path.join(basedir, 'db_models', 'migrations')

TICKET_DAEMON_URL = _local_settings.get_env('YEAH_TICKET_DAEMON_URL')

CELERYD_HIJACK_ROOT_LOGGER = False

LISTEN_PORT = _local_settings.get_env('YEAH_API_LISTEN_PORT', default='80')

LOG_PATH = _local_settings.get_env('YEAH_LOG_PATH', default='/var/log/yeah/logs.log')
