import logging
import time
from datetime import timedelta

from celery.exceptions import Ignore

from travel.avia.yeah import settings
from travel.avia.yeah.celery_app import celery_app
from travel.avia.yeah.services.ticket_daemon_api.client import td_api_client, QueryParams
from travel.avia.yeah.services.ticket_daemon_api.results_meta import ResultsMeta

logger = logging.getLogger(__name__)
NATIONAL_VERSION_DEFAULT_LANGS = {
    'ru': 'ru', 'ua': 'uk', 'tr': 'tr', 'com': 'en', 'kz': 'ru',
}


@celery_app.task(bind=True, rate_limit=settings.WARMING_UP_RATE_LIMIT)
def warming_up(self, query: dict, *args, **kwargs):
    logger.info('Process %r', query)
    query = QueryParams.from_dict(query)

    results_meta_response = td_api_client.results_meta(
        query.from_key, query.to_key, query.date_forward, query.date_backward,
        query.national_version, query.lang,
        adults=query.adults, children=query.children, infants=query.infants,
        service=query.service,
    )
    if results_meta_response.status == 'success':
        results_meta = ResultsMeta(results_meta_response.data)
        if results_meta.max_created is None:
            _do_init(query)
            return

        created_delta = timedelta(seconds=int(time.time()) - results_meta.max_created)
        if created_delta < timedelta(hours=3):
            raise Ignore('Query is actual')
        elif created_delta < timedelta(hours=6):
            raise self.retry(countdown=timedelta(hours=3).total_seconds(), max_retries=3)
        else:
            _do_init(query)
    else:
        raise self.retry(countdown=timedelta(minutes=10).total_seconds(), max_retries=3)


def _do_init(query: QueryParams):
    init_response = td_api_client.init_search(
        query.from_key, query.to_key, query.date_forward, query.date_backward,
        query.national_version, query.lang,
        adults=query.adults, children=query.children, infants=query.infants,
        service=query.service,
        partner_codes=(),
    )
    logger.info('Init search: %r', init_response)
