package main

import (
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/bitrix"
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/bitrix/client"
	"a.yandex-team.ru/travel/hotels/lib/go/ytstorage"
)

type hotelConfig struct {
	Schema bitrix.Config
	Client client.Config
}

type config struct {
	Hotels        map[string]*hotelConfig `config:"Hotels,required,backend=yaml" yaml:"hotels"`
	YT            ytstorage.Config
	ExportPath    string `config:"export-path,required"`
	BitrixSecrets string `config:"bitrix-secrets,backend=flags"`
}

var defaultConfig = config{
	YT:         ytstorage.DefaultConfig,
	ExportPath: "//home/travel/budapest/export",
}
