package main

import (
	"a.yandex-team.ru/travel/budapest/bitrix_sync/internal/app"
	"context"
	"fmt"
	"time"
)

func listDealsToChan(ctx context.Context, client *importerClient, hotelName string) <-chan interface{} {
	ch := make(chan interface{}, 50)
	put := func(v interface{}) bool {
		select {
		case ch <- v:
			return true
		case <-ctx.Done():
			return false
		}
	}
	go func() {
		defer close(ch)
		dealNum := 0
		pager := client.ListDeals()
		for {
			page, hasNext, err := pager.NextPage(context.Background())

			if err != nil {
				put(err)
				return
			}
			var deals []*deal
			for _, e := range page {
				d := e.(deal)
				d.Hotel = hotelName
				deals = append(deals, &d)
			}
			err = fillInContacts(client.client, deals)
			if err != nil {
				put(err)
				return
			}
			for _, d := range deals {
				put(d)
				dealNum += 1
			}
			fmt.Printf("%d deals loaded\n", dealNum)
			if !hasNext {
				break
			}
			app.SleepContext(ctx, 1*time.Second)
		}
	}()
	return ch
}
