package main

import (
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/bitrix"
	bxclient "a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/bitrix/client"
	"a.yandex-team.ru/travel/hotels/lib/go/ytstorage"
	"time"
)

type promoConfig struct {
	BitrixID        string     `yaml:"bitrix_id"`
	Stages          []string   `yaml:"stages"`
	MinCreationTime *time.Time `yaml:"min_creation_time"`
}

type hotelConfig struct {
	Client bxclient.Config
	Schema bitrix.Config
	Promo  map[string]*promoConfig
}

type config struct {
	YT            ytstorage.Config
	Path          string
	Hotels        map[string]*hotelConfig `config:"Hotels,required,backend=yaml" yaml:"hotels"`
	BitrixSecrets string                  `config:"bitrix-secrets,backend=flags"`
}

var defaultConfig = config{
	YT:   ytstorage.DefaultConfig,
	Path: "//home/travel/budapest",
}
